/**
  ******************************************************************************
  * @file    systemmemory_interface.c
  * @author  MCD Application Team
  * @brief   Contains System Memory access functions
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "platform.h"
#include "openbl_mem.h"
#include "common_interface.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
OPENBL_MemoryTypeDef FT_UID_Descriptor =
{
  .StartAddress = FT_UID_START_ADDRESS,
  .EndAddress = FT_UID_END_ADDRESS,
  .Size = FT_UID_END_ADDRESS - FT_UID_START_ADDRESS,
  .Type = AREA_SYS,
  .Read = Common_Direct_Read,
  .Write = NULL,
  .EraseChip = NULL,
  .EraseBank = NULL,
  .EraseBlock = NULL,
  .EraseSector = NULL,
  .ErasePage = NULL,
  .JumpToAddress = NULL,
};
